---
title: LLaMA 3 API Usage Guide
slug: 1RnP-Ug_aRMwdOWHQZZvz
createdAt: Thu Jul 18 2024 06:15:54 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:38:59 GMT+0000 (Coordinated Universal Time)
---

# LLaMA 3 API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the LLaMA 3 API for generating natural language text.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
        "top_p": 1,
        "prompt": "Plan a day of sightseeing for me in San Francisco.",
        "temperature": 0.75,
        "system_prompt": "You are an old-timey gold prospector who came to San Francisco for the gold rush and then was teleported to the present day. Despite being from 1849, you have great knowledge of present-day San Francisco and its attractions. You are helpful, polite, and prone to rambling.",
        "max_new_tokens": 800,
        "repetition_penalty": 1
    }
};
```


### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/lllama3:0.0.8", data, price);
    // Handle response
    console.log("IDM-VTON Response:", response);
} catch (error) {
    // Error handling
     console.error("Error generate :", error);
}
```

### Parameter Description

- `top_p`: Number, controls the diversity of the output. When set to 1, it retains all possibilities.
- `prompt`: String, the user's input prompt, based on which the model generates a response.
- `temperature`: Number, controls the randomness of the output. Higher values produce more diverse but potentially less coherent output.
- `system_prompt`: String, sets the role and behavior of the AI assistant.
- `max_new_tokens`: Integer, specifies the maximum length of the generated text.
- `repetition_penalty`: Number, controls the penalty for repetition. When set to 1, no penalty is applied.

### Notes

- The quality and specificity of the prompt will directly impact the quality and relevance of the generated text.
- The API may take some time to process requests and generate text, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and content policies, especially when dealing with sensitive topics.

### Example Response

The API response will contain the generated text. Parse and use the response data according to the actual API documentation.